;----------------------------------------------------------------------------
;    MODULE NAME:   IceAddToOrca.MM
;
;        $Author:   USER "Dennis"  $
;      $Revision:   1.2  $
;          $Date:   22 Jul 2006 10:07:42  $
;       $Logfile:   C:/DBAREIS/Projects.PVCS/Win32/MakeMsi/IceAddToOrca.MM.pvcs  $
;      COPYRIGHT:   (C)opyright Dennis Bareis, Australia, 2003
;                   All rights reserved.
;
; DESCRIPTION
; ~~~~~~~~~~~
; Creates an MSI which updates ORCA's menu to include a new CUB file.
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;--- Define validation Suite and ensure it exists ---------------------------
;----------------------------------------------------------------------------
#define CUB_FILE  out\ICE.mm\MSI\Validations Plus Custom (by Dennis Bareis).CUB
#if FileQueryExists("<$CUB_FILE>") = ''
    #error ^The CUB file "<$CUB_FILE>"{NL}doesn't exist!{NL}{NL}Have you built it using "ICE.MM" yet?^
#endif


;----------------------------------------------------------------------------
;--- Load MAKEMSI (via wrapper) ---------------------------------------------
;----------------------------------------------------------------------------
#define? COMPANY_MSINAME_SUFFIX.D       ;;"DENNIS.MMH" specified "(TEST)"
#include "DENNIS.MMH"


;----------------------------------------------------------------------------
;--- Create INSTALLDIR ------------------------------------------------------
;----------------------------------------------------------------------------
<$DirectoryTree Key="INSTALLDIR" Dir="c:\program files\<$ProdInfo.ProductName>" CHANGE="\" PrimaryFolder="Y">


;----------------------------------------------------------------------------
;--- Create a qualified component holding the file --------------------------
;----------------------------------------------------------------------------
<$Component "DBVALID.CUB" Create="Y" Directory_="INSTALLDIR">
   ;--- Add the CUB file to this component (make Keypath) -------------------
   <$Files "<$CUB_FILE>" KeyFile="*">

   ;--- Qualify this component ----------------------------------------------
   <$Table "PublishComponent">
   #(
       <$Row
              Feature_="<$Feature?>"                              ;;"Current" feature's name.
            Component_="<$Component?>"                            ;;"Current" component's name. I THINK the keypath is used by ORCA to know which ICE DB to run...
           ComponentId="{DC441E1D-3ECB-4DCF-B0A5-791F9C0F4F5B}"   ;;GUID obtained by examining the ORCA MSI
             Qualifier="<$ProdInfo.ProductName><$ProductVersion>" ;;Any (I assume unique) identifier will do...
               AppData=^Validation suite created by "ICE.MM"^     ;;Text ORCA will display in it's menu
       >
   #)
   <$/Table>
<$/Component>

